// const cameraConfigurations = [
//     {
//         name: 'camera1',
//         streamUrl: 'rtsp://dev:rezaIpCctv1402@192.168.20.43:554/cam/realmonitor?channel=1&subtype=1&unicast=true&proto=Onvif',
//         wsPort: 9999,
//         ffmpegOptions: {
//             '-stats': '',
//             '-r': 30,
//         },
//     },
//     {
//         name: 'camera2',
//         streamUrl: 'rtsp://dev:rezaIpCctv1402@192.168.20.44:554/cam/realmonitor?channel=1&subtype=1&unicast=true&proto=Onvif',
//         wsPort: 10000,
//         ffmpegOptions: {
//             '-stats': '',
//             '-r': 30,
//         },
//     },
// ];
//
// Stream = require('node-rtsp-stream')
//
// const streams = {};
//
// cameraConfigurations.forEach((config) => {
//     const stream = new Stream({
//         name: config.name,
//         streamUrl: config.streamUrl,
//         wsPort: config.wsPort,
//         ffmpegOptions: config.ffmpegOptions,
//     });
//
//     streams[config.name] = stream;
// });



const fs = require('fs');
const cameraConfigurations = JSON.parse(fs.readFileSync('camerasConfiguration.json'));

Stream = require('node-rtsp-stream');
const streams = [];

cameraConfigurations.forEach((config) => {
    // const stream = new Stream({
    //     name: config.name,
    //     url: config.streamUrl,
    //     wsPort: config.wsPort,
    // });
    // stream.start();
    // streams.push(stream);

    const stream = new Stream({
        name: config.name,
        streamUrl: config.streamUrl,
        wsPort: config.wsPort,
        ffmpegOptions: config.ffmpegOptions,
    });
    streams[config.name] = stream;
});


const AudioStream = require('node-rtsp-stream');

cameraConfigurations.forEach((config) => {
    const audioStream = new AudioStream({
        name: config.name,
        streamUrl: config.audioStreamUrl,
        wsPort: config.wsPort + 1,
        ffmpegOptions: config.ffmpegOptions,
    });

    streams[config.name + '_audio'] = audioStream;
});


