const Stream = require('node-rtsp-stream');

const streams = {};

const cameraConfigurations = [
    {
        name: 'camera1',
        streamUrl: 'rtsp://dev:rezaIpCctv1402@192.168.20.43:554/cam/realmonitor?channel=1&subtype=1&unicast=true&proto=Onvif',
        wsPort: 9999,
        ffmpegOptions: {
            '-stats': '',
            '-r': 30,
        },
    },
    {
        name: 'camera2',
        streamUrl: 'rtsp://dev:rezaIpCctv1402@192.168.20.44:554/cam/realmonitor?channel=1&subtype=1&unicast=true&proto=Onvif',
        wsPort: 10000,
        ffmpegOptions: {
            '-stats': '',
            '-r': 30,
        },
    },
];

cameraConfigurations.forEach((config) => {
    const stream = new Stream({
        name: config.name,
        streamUrl: config.streamUrl,
        wsPort: config.wsPort,
        ffmpegOptions: config.ffmpegOptions,
    });

    streams[config.name] = stream;
});